# Tworzenie pliku wordPatterns.py:
# https://www.nostarch.com/crackingcodes (na licencji BSD).

# Tworzy plik wordPatterns.py na podstawie słów znajdujących się
# w pliku słownika dictionary.txt. (Ten plik umieściłem pod adresem
# https://invpy.com/dictionary.txt)

import pprint


def getWordPattern(word):
    # Zwraca ciąg tekstowy wzorca na podstawie danego słowa,
    # na przykład '0.1.2.3.4.1.2.3.5.6' dla słowa 'DUSTBUSTER'
    word = word.upper()
    nextNum = 0
    letterNums = {}
    wordPattern = []

    for letter in word:
        if letter not in letterNums:
            letterNums[letter] = str(nextNum)
            nextNum += 1
        wordPattern.append(letterNums[letter])
    return '.'.join(wordPattern)


def main():
    allPatterns = {}

    fo = open('dictionary.txt')
    wordList = fo.read().split('\n')
    fo.close()

    for word in wordList:
        # Pobiera wzorzec dla każdego ciągu tekstowego w wordList:
        pattern = getWordPattern(word)

        if pattern not in allPatterns:
            allPatterns[pattern] = [word]
        else:
            allPatterns[pattern].append(word)

    # To jest kod zapisujący dane. Plik wordPatterns.py zawiera jedno
    # naprawdę ogromne polecenie przypisania:
    fo = open('wordPatterns.py', 'w')
    fo.write('allPatterns = ')
    fo.write(pprint.pformat(allPatterns))
    fo.close()


if __name__ == '__main__':
    main()
